package doABC;

import java.nio.ByteBuffer;
import java.util.*;

import FlashReader.*;

public class ClassInfo extends SwfTools{
	
	private int id;
	private AbcFile abc;
	private int start=0;
	private int end=0;
	
	//struktury
	private int  cinit;
	private int trait_count;
	private ArrayList<TraitInfo> tinfo = new ArrayList<TraitInfo>();//optional
	
	public  ClassInfo(AbcFile abc,int  cinit, int trait_count, ArrayList<TraitInfo> tinfo) {
		super();
		this.abc = abc;
		abc.ENclass_info.add(this);
		id = abc.ENclass_info.size()-1;
		
		this.cinit = cinit;
		this.trait_count = trait_count;
		if (tinfo !=null)
			this.tinfo = tinfo;	
	}	
	
	private ClassInfo(AbcFile abc) {
		super();
		this.abc = abc;
		abc.ENclass_info.add(this);
		id = abc.ENclass_info.size()-1;
	}	
	
	public static void class_info(ByteBuffer bbuf, int position, CpoolInfo cpool, AbcFile abc){
		try{
		bbuf.position(position);
		for (int i=0; i<InstanceInfo.class_count;i++){
			
			
			ClassInfo class_info = new ClassInfo( abc);
			class_info.start = bbuf.position();
			
			class_info.cinit = unsigned30int(bbuf);
			
			class_info.trait_count = unsigned30int(bbuf);
			
			for (int i2 =0;i2 < class_info.trait_count; i2++)
				class_info.tinfo.add(new TraitInfo(abc,bbuf));

			abc.methodsNames.put(class_info.cinit,(String) abc.ENinstance_info.get(i).getName_string()+"$cinit");
			
			class_info.end = bbuf.position()-1;
		}
		
	} catch (Exception e) {e.printStackTrace();}
	}
	
	//tobytecodes
	
	public ArrayList<Byte> toByteCode(){
		ArrayList<Byte> result = new ArrayList<Byte>();
		
			for(byte b: getUI32(cinit))
				result.add(b);
			
			for(byte b: getUI32(trait_count))
				result.add(b);

			for (int i=0;i<tinfo.size();i++){
				for(byte b: tinfo.get(i).toByteCode())
					result.add(b);
			}

		return result;
	}
	
	
	
	//getters
	
	public int getId() {
		return id;
	}
	
	public int getStart() {
		return start;
	}

	public int getEnd() {
		return end;
	}

	public int getCinit() {
		return cinit;
	}

	public ArrayList<TraitInfo> getTinfo() {
		return tinfo;
	}

	public int getTrait_count() {
		return trait_count;
	}
	
	//setters
	
	public void removeClass(int id){
		abc.ENclass_info.remove(id);
	}
	
	public void addTinfo(TraitInfo tinfo){
		this.tinfo.add(tinfo);
		trait_count++;
		out("ok");
	}
	
	public void removeTinfo(int id){
		this.tinfo.remove(id);
		trait_count--;
		out("ok");
	}
	
	public void changeTinfo(int id, TraitInfo tinfo){
		this.tinfo.set(id, tinfo);;
		out("ok");
	}
	
	public void setCinit(int cinit) {
		this.cinit = cinit;
		out("ok");
	}

	//toStrings

	public String toString(){
		String wynik ="";
		wynik+="class_info id "+id + " " +start+ " - " + end;
		return wynik;
	}
	public String toString2(){
		String wynik ="";
		wynik+="class_info";
		return wynik;
	}
	
	
	public  String String(){
		StringBuffer wynik = new StringBuffer();

			wynik.append( ">" + getStart() +"\n" );
			
			wynik.append( "cinit: "+ getCinit()+"\n" );
			
			wynik.append( "trait_count: "+ getTrait_count()+"\n" );
			
			//wynik+= "traits_info: "+getTinfo();		
			
			wynik.append( "<" + getEnd() +"\n" );
		
		return wynik.toString();
	}
	

}
